directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data
end_data;

instrument

  gl_scene scene;
    activity
      period = 0.05;
    end_activity;
    gui
      owner = background;
      position = 15, 35, 800, 600;
      window
        type = normal;
        title = 'Lens Flares';
      end_window;
    end_gui;
    light
      light0
        position = -2, 2, -2, 1;
      end_light0;
    end_light;
    volumetric_shadows = true;
    glow = 2;
    fog
      mode = linear;
      color = 6, 21, 25;
      start = 800;
      termination = 1500;
    end_fog;
    camera
      position = 0, 0, 1.12E+3;
      rotation = 0, 0;
      lens_flares = light_and_flares_fixed;
    end_camera;

    procedure OnActivate();
    static
      y : real, 0;
      lx : real, 0;
      ly : real, 0;
      angle : real, 0;
      time : real, 0;
    begin
      y := y + 0.022;
      if y > 2 * Pi then
        y = y - 2 * Pi;
      end;
    
      lx := sin( y ) * 5;
      ly := cos( y ) * 2;
    
      angle := angle + 0.62;
      if angle  > 360 then
        angle := angle - 360;
      end;
    
      scene.SetLightPosition( 0, ly , 0.9, lx - 3.5 , 1 );
      miilogo.Rotate( angle, 0, 1, 0 );
    
      time = GetRenderTime();
      if time <> 0 then
        fps_meter.SetValue( 1 / time );
      else
        fps_meter.SetValue( 1000 );
      end;
    end_procedure;

  end_gl_scene;

  gl_segment_display fps_meter;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'center_limit';
        ambient = 0.000, 0.229, 0.642, 1.000;
        diffuse = 0.385, 0.587, 1.000, 1.000;
        specular = 1.000, 1.000, 0.797, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.100;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
    end_material;
    location
      translate = -149, -78.1, 753;
      rotate = 0, 0, 0, 1;
      scale = 1, 1, 1;
    end_location;
    look = look_2;
    range_to = 1000;
    low_limit = 0;
    high_limit = 1000;
    dec_places = 0;
  end_gl_segment_display;

  gl_shape gl_shape_3;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.000, 0.100, 0.100, 1.000;
        diffuse = 0.000, 0.697, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = true;
        texture = 'marble01.gif';
      end_item;
    end_material;
    location
      translate = 95.4, -71.5, 804;
      rotate = 120, -0.5774, 0.5774, 0.5774;
      scale = 1.7, 2.5, 1.76;
    end_location;
    look = cylinder;
  end_gl_shape;

  gl_shape gl_shape_2;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.045, 0.100, 0.100, 1.000;
        diffuse = 0.651, 0.798, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = true;
        texture = 'marble03.jpg';
      end_item;
    end_material;
    location
      translate = 149, -43.8, 740;
      rotate = 0, 0, 0, 1;
      scale = 4.44, 4.44, 4.44;
    end_location;
    look = cone;
  end_gl_shape;

  gl_poster floor;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'bricks06_ambient.jpg';
        normalmap = 'bricks06_normalmap.jpg';
        heightmap = 'bricks06_heightmap.jpg';
      end_item;
    end_material;
    location
      translate = -1.71, -87.2, -7.25;
      rotate = 90, -1, 0, 0;
      scale = 9.93, 11.7, 5.73;
    end_location;
    common_3D
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 10;
    x_tex_repeat = 12;
  end_gl_poster;

  gl_model miilogo;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'mat_em';
        ambient = 0.050, 0.050, 0.050, 1.000;
        diffuse = 0.000, 0.502, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.394;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = true;
      end_item;
      item
        name = 'mat_grid';
        ambient = 0.009, 0.064, 0.091, 1.000;
        diffuse = 0.000, 0.502, 0.577, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.238;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = true;
      end_item;
      item
        name = 'mat_text';
        ambient = 0.000, 0.059, 0.059, 1.000;
        diffuse = 0.000, 0.761, 0.753, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.128;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = true;
      end_item;
    end_material;
    location
      translate = 7.85, 79.2, 338;
      rotate = 0, 0, 1, 0;
      scale = 1.99, 1.99, 1.99;
    end_location;
    smoothing_angle = 30;
    file = 'miilogo_cz.obj';
  end_gl_model;

end_instrument;

